// priority: 16

let 解析材料 = (材料字符串) => {
    if (!材料字符串) return { count: 1, item: Item.of("minecraft:barrier").withName("§c未定义") };
    let 匹配 = 材料字符串.match(/(\d+)x\s*(.+)/);
    if (匹配) return { count: parseInt(匹配[1]), item: Item.of(匹配[2].trim()).withCount(parseInt(匹配[1])) };
    return { count: 1, item: Item.of(材料字符串.trim()).withCount(1) };
};

let 生成结构方块 = (结构数据) => {
    let 最终方块 = [];
    if (结构数据) {
        结构数据.forEach(单个材料字符串 => {
            let 已解析 = 解析材料(单个材料字符串);
            for (let i = 0; i < 已解析.count; i++) {
                if (最终方块.length < 12) { 最终方块.push(Item.of(已解析.item.id)); }
            }
        });
    }
    while (最终方块.length < 12) { 最终方块.push(Item.of("minecraft:stone")); }
    return 最终方块;
};

JEIAddedEvents.registerCategories(e => {
    let 界面助手 = e.JEI_HELPERS.guiHelper;
    let 画布宽度 = 200;
    let 画布高度 = 160;
    let 字体 = Client.font;
    let 白色 = 0xFFFFFF; 

    // --- 分类 1: 水池仪式 ---
    e.custom("xyat:pool_ritual", 类别 => {
        // --- “仪式高度”文字的坐标 ---
        let 高度文本_X = 95;
        let 高度文本_Y = 90;
        // --- 新增：“需要结构”文字的坐标 ---
        let 结构文本_X = 95;
        let 结构文本_Y = 100;
        // --- “需要经验点数”文字的坐标 ---
        let 经验文本_X = 95;
        let 经验文本_Y = 110;
        // --- “仅限维度”文字的坐标 ---
        let 维度文本_X = 95;
        let 维度文本_Y = 120;
        // --- “获得产物”文字的坐标 ---
        let 产物文本_X = 95;
        let 产物文本_Y = 140;
        // --- “产物”物品（例如靴子）的坐标 ---
        let 产物物品_Y = 138;

        类别.width = 画布宽度;
        类别.height = 画布高度;
        类别.title(Text.of("水池仪式"))
            .background(界面助手.createDrawable(new ResourceLocation("kubejs", "textures/pool_background.png"), 0, 0, 画布宽度, 画布高度))
            .icon(界面助手.createDrawableItemStack(Item.of("minecraft:water_bucket")))
            .handleLookup((构造器, 配方数据) => {
                let 所有材料 = 配方数据.data["合成材料"].map(解析材料);
                所有材料.push({ item: Item.of("minecraft:lapis_lazuli") });
                let 输入网格起始X = Math.floor((画布宽度 - Math.min(所有材料.length, 10) * 18) / 2);
                let 材料起始Y = 12;
                所有材料.forEach((单个材料, 索引) => {
                    构造器.addSlot("INPUT", 输入网格起始X + (索引 % 10) * 18, 材料起始Y + Math.floor(索引 / 10) * 18).addItemStack(单个材料.item);
                });
                let 结构起始X = 5;
                let 结构起始Y轴 = 85;
                let 待渲染方块 = 生成结构方块(配方数据.data["结构方块"]);
                let 方块索引 = 0;
                for (let i = 0; i < 4; i++) {
                    构造器.addSlot("CATALYST", 结构起始X + i * 18, 结构起始Y轴).addItemStack(待渲染方块[方块索引++]);
                    构造器.addSlot("CATALYST", 结构起始X + i * 18, 结构起始Y轴 + 3 * 18).addItemStack(待渲染方块[方块索引++]);
                }
                for (let i = 1; i < 3; i++) {
                    构造器.addSlot("CATALYST", 结构起始X, 结构起始Y轴 + i * 18).addItemStack(待渲染方块[方块索引++]);
                    构造器.addSlot("CATALYST", 结构起始X + 3 * 18, 结构起始Y轴 + i * 18).addItemStack(待渲染方块[方块索引++]);
                }
                构造器.addSlot("CATALYST", 结构起始X + 18, 结构起始Y轴 + 18).addFluidStack("minecraft:water", 1000);
                构造器.addSlot("CATALYST", 结构起始X + 36, 结构起始Y轴 + 18).addFluidStack("minecraft:water", 1000);
                构造器.addSlot("CATALYST", 结构起始X + 18, 结构起始Y轴 + 36).addFluidStack("minecraft:water", 1000);
                构造器.addSlot("CATALYST", 结构起始X + 36, 结构起始Y轴 + 36).addFluidStack("minecraft:water", 1000);
                let 产物文本 = "获得产物";
                let 产物物品_X = 产物文本_X + 字体.width(产物文本) + 3;
                let 输出物品 = 解析材料(配方数据.data["输出物品"]);
                构造器.addSlot("OUTPUT", 产物物品_X, 产物物品_Y).addItemStack(输出物品.item);
            })
            .setDrawHandler((配方数据, 槽位视图, 图形绘制器) => {
                let 顶部文本X = 5;
                图形绘制器.drawWordWrap(字体, Text.of("将以下材料投入水池中,最后投入青金石"), 顶部文本X, 2, 画布宽度 - 顶部文本X, 白色);
                let 结构起始Y轴 = 90;
                图形绘制器.drawWordWrap(字体, Text.of(配方数据.data["结构方块"] ? "水池要求:" : "水池要求: §c无限制"), 5, 结构起始Y轴 - 15, 80, 白色);
                
                if (配方数据.data["仪式高度"]) {
                    图形绘制器.drawWordWrap(字体, Text.of(`- 仪式高度: §5${配方数据.data["仪式高度"]}`), 高度文本_X, 高度文本_Y, 110, 白色);
                } else {
                    图形绘制器.drawWordWrap(字体, Text.of(`- 仪式高度: §c无限制`), 高度文本_X, 高度文本_Y, 110, 白色);
                }
                
                if (配方数据.data["需要结构"]) {
                    图形绘制器.drawWordWrap(字体, Text.of("- 需要结构: ").append(Text.of(`§6${配方数据.data["需要结构"]}`)), 结构文本_X, 结构文本_Y, 110, 白色);
                }

                if (配方数据.data["需要经验值"]) {
                    图形绘制器.drawWordWrap(字体, Text.of("- 需要经验点数: ").append(Text.of(`§c${配方数据.data["需要经验值"]}`)), 经验文本_X, 经验文本_Y, 110, 白色);
                }

                if (配方数据.data["维度"]) {
                    图形绘制器.drawWordWrap(字体, Text.of("- 仅限维度: ").append(Text.of(`§a${配方数据.data["维度"].join(", ")}`)), 维度文本_X, 维度文本_Y, 110, 白色);
                }
                图形绘制器.drawWordWrap(字体, Text.of("获得产物:"), 产物文本_X, 产物文本_Y, 90, 白色);
            });
    });

    // --- 分类 2: 闪电仪式 ---
    e.custom("xyat:lightning_ritual", 类别 => {
        let 闪电画布宽度 = 200;
        let 闪电画布高度 = 125;
        类别.width = 闪电画布宽度;
        类别.height = 闪电画布高度;
        类别.title(Text.of("闪电仪式"))
            .background(界面助手.createDrawable(new ResourceLocation("kubejs", "textures/lightning_background.png"), 0, 0, 闪电画布宽度, 闪电画布高度))
            .icon(界面助手.createDrawableItemStack(Item.of("touhou_little_maid:entity_placeholder")))
            .handleLookup((构造器, 配方数据) => {
                let 所有材料 = 配方数据.data["合成材料"].map(解析材料);
                所有材料.forEach((单个材料, 索引) => 构造器.addSlot("INPUT", 10 + (索引 % 8) * 18, 32 + Math.floor(索引 / 8) * 18).addItemStack(单个材料.item));
                let 输出物品 = 解析材料(配方数据.data["输出物品"]);
                构造器.addSlot("OUTPUT", 150, 41).addItemStack(输出物品.item);
            })
            .setDrawHandler((配方数据, 槽位视图, 图形绘制器) => {
                let 字体 = Client.font;
                let 画布宽度 = 200;
                图形绘制器.drawWordWrap(字体, Text.of("等待§5闪电§0劈中"), 0, 2, 画布宽度, 白色);
                图形绘制器.drawWordWrap(字体, Text.of("需要材料:"), 10, 20, 80, 白色);
                图形绘制器.drawWordWrap(字体, Text.of("获得产物:"), 140, 29, 80, 白色);
                
                let 信息行 = [];

                if (配方数据.data["需要结构"]) 信息行.push(Text.of(`- 需要结构: §6${配方数据.data["需要结构"]}`));
                if (配方数据.data["需要经验值"]) 信息行.push(Text.of(`- 需要经验点数: §c${配方数据.data["需要经验值"]}`));
                if (配方数据.data["维度"]) 信息行.push(Text.of("- 仅限维度: ").append(Text.of(`§5${配方数据.data["维度"].join(", ")}`)));
                if (配方数据.data["需要进度"]) 信息行.push(Text.of(`- 需要进度:\n  §5${配方数据.data["需要进度"]}`));
                if (配方数据.data["闪电Y轴限制"]) 信息行.push(Text.of(`- 闪电最低Y轴: §5${配方数据.data["闪电Y轴限制"]}`));

                if (信息行.length > 0) {
                    let 当前Y轴 = 55;
                    信息行.forEach(行 => {
                        图形绘制器.drawWordWrap(字体, 行, 0, 当前Y轴, 120, 白色);
                        当前Y轴 += (行.getString().includes("\n") ? 20 : 10);
                    });
                }
            });
    });
});

JEIAddedEvents.registerRecipes(e => {
    if (global.世界交互配方列表) {
        global.世界交互配方列表.forEach(配方数据 => {
            let 触发方式 = 配方数据["触发方式"] || "全部";
            if (触发方式 === "水池" || 触发方式 === "全部") {
                e.custom("xyat:pool_ritual").add(配方数据);
            }
            if (触发方式 === "闪电" || 触发方式 === "全部") {
                e.custom("xyat:lightning_ritual").add(配方数据);
            }
        });
    }
});